!-----------------------------------------------------------------------
! Wsock32.clw  Include file             4/23/98
!
! Ed Rees                               Ed.Rees@infopackaging.com
! Information Packaging Unlimited       
! 105 Forrest Ave, Suite 7              www.infopackaging.com
! Narberth PA 19072                     www.cwsuperpage.com
! 610.617.8820
!***********************************************************************
!

    SECTION('Equates')

SOCK32_ERROR            EQUATE(65535)
s32_Version1_1          EQUATE(100000001b)  !mask for requesting version 1.1
s32_Version2_0          EQUATE(1000000010b) !mask for requesting version 2.0


            ! socket types
SOCK32_STREAM           EQUATE(1)           !stream socket
SOCK32_DGRAM            EQUATE(2)           !datagram socket
SOCK32_RAW              EQUATE(3)           !raw-protocol interface
SOCK32_RDM              EQUATE(4)           !reliable-delivered message
SOCK32_SEQPACKET        EQUATE(5)           !sequenced packet stream

            ! socket options
SO_DEBUG                EQUATE(0001H)       !turn on debugging
SO_ACCEPTCONN           EQUATE(0002H)       !socket has had listen()
SO_REUSEADDR            EQUATE(0004H)       !allow local address reuse
SO_KEEPALIVE            EQUATE(0008H)       !keep connections alive
SO_DONTROUTE            EQUATE(0010H)       !just use interface addresses
SO_BROADCAST            EQUATE(0020H)       !permit sending of broadcast messages
SO_USELOOPBACK          EQUATE(0040H)       !bypass hardware when possible
SO_LINGER               EQUATE(0080H)       !linger on close if data present
SO_OOBINLINE            EQUATE(0100H)       !leave received OOB data in line
SO_SNDBUF               EQUATE(1001h)       !send buffer size
SO_RCVBUF               EQUATE(1002h)       !receive buffer size
SO_SNDLOWAT             EQUATE(1003h)       !send lo-water mark
SO_RCVLOWAT             EQUATE(1004h)       !receive lo-water mark
SO_SNDTIMEO             EQUATE(1005h)       !send timeout
SO_RCVTIMEO             EQUATE(1006h)       !receive timeout
SO_ERROR                EQUATE(1007h)       !get error status and clear
SO_TYPE                 EQUATE(1008h)       !get socket type

            ! errors
WSAEINTR                EQUATE(10004)
WSAEBADF                EQUATE(10009)
WSAEACCES               EQUATE(10013)
WSAEFAULT               EQUATE(10014)
WSAEINVAL               EQUATE(10022)
WSAEMFILE               EQUATE(10024)

WSAEWOULDBLOCK          EQUATE(10035)
WSAEINPROGRESS          EQUATE(10036)
WSAEALREADY             EQUATE(10037)
WSAENOTSOCK             EQUATE(10038)
WSAEDESTADDRREQ         EQUATE(10039)
WSAEMSGSIZE             EQUATE(10040)
WSAEPROTOTYPE           EQUATE(10041)
WSAENOPROTOOPT          EQUATE(10042)
WSAEPROTONOSUPPORT      EQUATE(10043)
WSAESOCKTNOSUPPORT      EQUATE(10044)
WSAEOPNOTSUPP           EQUATE(10045)
WSAEPFNOSUPPORT         EQUATE(10046)
WSAEAFNOSUPPORT         EQUATE(10047)
WSAEADDRINUSE           EQUATE(10048)
WSAEADDRNOTAVAIL        EQUATE(10049)
WSAENETDOWN             EQUATE(10050)
WSAENETUNREACH          EQUATE(10051)
WSAENETRESET            EQUATE(10052)
WSAECONNABORTED         EQUATE(10053)
WSAECONNRESET           EQUATE(10054)
WSAENOBUFS              EQUATE(10055)
WSAEISCONN              EQUATE(10056)
WSAENOTCONN             EQUATE(10057)
WSAESHUTDOWN            EQUATE(10058)
WSAETOOMANYREFS         EQUATE(10059)
WSAETIMEDOUT            EQUATE(10060)
WSAECONNREFUSED         EQUATE(10061)
WSAELOOP                EQUATE(10062)
WSAENAMETOOLONG         EQUATE(10063)
WSAEHOSTDOWN            EQUATE(10064)
WSAEHOSTUNREACH         EQUATE(10065)
WSAENOTEMPTY            EQUATE(10066)
WSAEPROCLIM             EQUATE(10067)
WSAEUSERS               EQUATE(10068)
WSAEDQUOT               EQUATE(10069)
WSAESTALE               EQUATE(10070)
WSAEREMOTE              EQUATE(10071)

WSASYSNOTREADY          EQUATE(10091)
WSAVERNOTSUPPORTED      EQUATE(10092)
WSANOTINITIALISED       EQUATE(10093)

WSAHOST_NOT_FOUND       EQUATE(11001)
HOST_NOT_FOUND          EQUATE(11001)
WSATRY_AGAIN            EQUATE(11002)
TRY_AGAIN               EQUATE(11002)
WSANO_RECOVERY          EQUATE(11003)
NO_RECOVERY             EQUATE(11003)
WSANO_DATA              EQUATE(11004)
NO_DATA                 EQUATE(11004)

            ! ioctl constants
IOCPARM_MASK            EQUATE(127)
IOC_VOID                EQUATE(020000000h)
IOC_OUT                 EQUATE(040000000h)
IOC_IN                  EQUATE(080000000h)
IOC_INOUT               EQUATE(0C0000000h)

FD_SETSIZE              EQUATE(64)

            ! protocol constants
IPPROTO_IP              EQUATE(0)           !dummy for IP
IPPROTO_ICMP            EQUATE(1)           !control message protocol
IPPROTO_GGP             EQUATE(2)           !gateway
IPPROTO_TCP             EQUATE(6)           !tcp
IPPROTO_PUP             EQUATE(12)          !pup
IPPROTO_UDP             EQUATE(17)          !user datagram protocol
IPPROTO_IDP             EQUATE(22)          !xns idp
IPPROTO_ND              EQUATE(77)          !net disk protocol (unofficial)
IPPROTO_RAW             EQUATE(255)         !raw IP packet
IPPROTO_MAX             EQUATE(256)         !

            ! port/socket numbers
IPPORT_ECHO             EQUATE(7  )         !
IPPORT_DISCARD          EQUATE(9  )         !
IPPORT_SYSTAT           EQUATE(11 )         !
IPPORT_DAYTIME          EQUATE(13 )         !
IPPORT_NETSTAT          EQUATE(15 )         !
IPPORT_FTP              EQUATE(21 )         !
IPPORT_TELNET           EQUATE(23 )         !
IPPORT_SMTP             EQUATE(25 )         !
IPPORT_TIMESERVER       EQUATE(37 )         !
IPPORT_NAMESERVER       EQUATE(42 )         !
IPPORT_WHOIS            EQUATE(43 )         !
IPPORT_MTP              EQUATE(57 )         !
IPPORT_TFTP             EQUATE(69 )         !
IPPORT_RJE              EQUATE(77 )         !
IPPORT_FINGER           EQUATE(79 )         !
IPPORT_TTYLINK          EQUATE(87 )         !
IPPORT_SUPDUP           EQUATE(95 )         !
IPPORT_EXECSERVER       EQUATE(512)         !
IPPORT_LOGINSERVER      EQUATE(513)         !
IPPORT_CMDSERVER        EQUATE(514)         !
IPPORT_RESERVED         EQUATE(1024)        !

            ! flags to use with WSAAsyncSelect
FD_READ                 EQUATE(01h)
FD_WRITE                EQUATE(02h)
FD_OOB                  EQUATE(04h)
FD_ACCEPT               EQUATE(08h)
FD_CONNECT              EQUATE(10h)
FD_CLOSE                EQUATE(20h)

            ! address families
AF_UNSPEC               EQUATE(0)           !unspecified
AF_UNIX                 EQUATE(1)           !local to host (pipes, portals
AF_INET                 EQUATE(2)           !internetwork: UDP,TCP
AF_IMPLINK              EQUATE(3)           !arpanet IMP addresses
AF_PUP                  EQUATE(4)           !pup protocols
AF_CHAO                 EQUATE(5)           !MIT Chaos protocols
AF_NS                   EQUATE(6)           !Xerox NS protocols
AF_ISO                  EQUATE(7)           !ISO Protocols
AF_OSI                  EQUATE(7)           !OSI same as ISO
AF_ECMA                 EQUATE(8)           !european
AF_DATAKIT              EQUATE(9)           !datakit protocols
AF_CCITT                EQUATE(10)          !CCITT protocols: X.25, etc
AF_SNA                  EQUATE(11)          !IBM SNA
AF_DECnet               EQUATE(12)          !DECnet
AF_DLI                  EQUATE(13)          !Direct data link interface
AF_LAT                  EQUATE(14)          !LAT
AF_HYLINK               EQUATE(15)          !NSC hyperchannel
AF_APPLETALK            EQUATE(16)          !Appletalk
AF_NETBIOS              EQUATE(17)          !NetBios-style addresses

            ! misc definitions
SOL_SOCKET              EQUATE(0ffffh)      !options for socket level
SOMAXCONN               EQUATE(5)           !
MSG_OOB                 EQUATE(1h)          !process out-of-band data
MSG_PEEK                EQUATE(2h)          !peek at incoming message
MSG_DONTROUTE           EQUATE(4h)          !send w/o using routing table
MSG_MAXIOVLEN           EQUATE(16)          !
MAXGETHOSTSTRUCT        EQUATE(1024)        !used by gethostbyXXXX routines, max size
TCP_NODELAY             EQUATE(0001h)

IP_OPTIONS              EQUATE(1)

INADDR_ANY              EQUATE(0)
INADDR_LOOPBACK         EQUATE(7f000001h)
INADDR_BROADCAST        EQUATE(0ffffffffh)
INADDR_NONE             EQUATE(0ffffffffh)


!****************************************************************
!Structure definitions
!****************************************************************
SOCKET                  EQUATE(USHORT)

FD_SET                  GROUP,TYPE
FD_COUNT                  USHORT
FD_ARRAY                  SOCKET,DIM(FD_SETSIZE)
                        END !group

HOSTENT                 GROUP,TYPE
h_name                    LONG !&CSTRING    !name of host           (ptr)
h_aliases                 LONG !&&CSTRING   !alias list             (ptr to arr of ptrs)
h_addrtype                SHORT             !host address type
h_length                  SHORT             !length of address
h_addr_list               LONG !&&CSTRING   !list of addresses      (ptr to arr of ptrs)
                        END

SERVENT                 GROUP,TYPE
S_NAME                    LONG !&CSTRING    !service name           (ptr)
S_ALIASES                 LONG !&&CSTRING   !alias list             (ptr to arr of ptrs)
S_PORT                    SHORT             !port number
S_PROTO                   LONG !&CSTRING    !protocol to use        (ptr)
                        END

NETENT                  GROUP,TYPE
N_NAME                    LONG !&CSTRING    !name of net            (ptr)
N_ALIASES                 LONG !&&CSTRING   !alias list             (ptr to arr of ptrs)
N_ADDRTYPE                SHORT             !net address type
N_NET                     ULONG             !network number
                        END

PROTOENT                GROUP,TYPE
P_NAME                    LONG !&CSTRING    !protocol name          (ptr)
P_ALIASES                 LONG !&&CSTRING   !alias list             (ptr to arr of ptrs)
P_PROTO                   SHORT             !protocol number
                        END

IN_ADDR                 GROUP,TYPE
S_UN                      GROUP
S_ADDR                      ULONG
S_UN_B                      GROUP,OVER(S_addr)
S_B1                          BYTE
S_B2                          BYTE
S_B3                          BYTE
S_B4                          BYTE
                            END
S_UN_W                      GROUP,OVER(S_addr)
S_W1                          USHORT
S_W2                          USHORT
                            END
                          END
                        END
S_ADDR                  EQUATE(IN_ADDR.S_UN.S_ADDR)
S_HOST                  EQUATE(IN_ADDR.S_UN.S_UN_B.S_B2)

WSAData                 GROUP,TYPE
wVersion                  SHORT
wHighVersion              SHORT
szDescription             CSTRING(257)             
szSystemStatus            CSTRING(129)             
iMaxSockets               USHORT
iMaxUdpDg                 USHORT
lpVendorInfo              CSTRING(257)        !  (not sure of size)
                        END

SOCKADDR_IN             GROUP,TYPE
sin_family                SHORT
sin_port                  USHORT
sin_addr                  LIKE(IN_ADDR),PRE(sin)
sin_zero                  CSTRING(8)
                        END

SOCKADDR                GROUP,TYPE
sa_family                 USHORT            !address family
sa_data                   CSTRING(14)       !up to 14 bytes of direct address
                        END

SOCKPROTO               GROUP,TYPE
sp_family                 USHORT            !address family
sp_protocol               USHORT            !protocol
                        END

LINGER                  GROUP,TYPE
l_onoff                   USHORT            !on/off option
l_linger                  USHORT            !linger time
                        END

    SECTION('Prototypes')

     MODULE('WSOCK32.LIB')
!
! gotta rename some functions, as they clash with Clarion (like "accept")
! so I decided that perhaps a s32 prefix would be good for all.....
!
! I also provide the Microsoft Prototype before each Clarion prototype, so you
! can catch any dumb things I did.  Please email me and let me know.....
!
        !SOCKET PASCAL FAR accept (SOCKET s, struct sockaddr FAR *addr,
        !                  int FAR *addrlen);
        s32_accept(SOCKET,LONG,LONG),SOCKET,RAW,PASCAL,NAME('ACCEPT'),DLL(dll_mode)


        !int PASCAL FAR bind (SOCKET s, const struct sockaddr FAR *addr, int namelen);
        s32_bind(SOCKET,*SOCKADDR_IN,SHORT),SHORT,RAW,PASCAL,NAME('BIND'),DLL(dll_mode)

        !int PASCAL FAR closesocket (SOCKET s);
        s32_closesocket(SOCKET),SHORT,RAW,PASCAL,NAME('CLOSESOCKET'),DLL(dll_mode)

        !int PASCAL FAR connect (SOCKET s, const struct sockaddr FAR *name, int namelen);
        s32_connect(SOCKET,*SOCKADDR_IN,SHORT),SHORT,RAW,PASCAL,NAME('CONNECT'),DLL(dll_mode)

        !int PASCAL FAR ioctlsocket (SOCKET s, long cmd, u_long FAR *argp);
        s32_ioctlsocket(SOCKET,LONG,*ULONG),SHORT,RAW,PASCAL,NAME('IOCTLSOCKET'),DLL(dll_mode)

        !int PASCAL FAR getpeername (SOCKET s, struct sockaddr FAR *name,
        !                   int FAR * namelen);
        s32_getpeername(SOCKET,*SOCKADDR,*SHORT),SHORT,RAW,PASCAL,NAME('GETPEERNAME'),DLL(dll_mode)

        !int PASCAL FAR getsockname (SOCKET s, struct sockaddr FAR *name,
        !                   int FAR * namelen);
        s32_getsockname(SOCKET,*SOCKADDR,*SHORT),SHORT,RAW,PASCAL,NAME('GETSOCKNAME'),DLL(dll_mode)

        !int PASCAL FAR getsockopt (SOCKET s, int level, int optname,
        !                  char FAR * optval, int FAR *optlen);
        s32_getsockopt(SOCKET,SHORT,SHORT,LONG,LONG),SHORT,RAW,PASCAL,NAME('GETSOCKOPT'),DLL(dll_mode)

        !u_long PASCAL FAR htonl (u_long hostlong);
        s32_htonl(ULONG),ULONG,PASCAL,NAME('HTONL'),DLL(dll_mode)

        !u_short PASCAL FAR htons (u_short hostshort);
        s32_htons(USHORT),USHORT,PASCAL,NAME('HTONS'),DLL(dll_mode)

        !unsigned long PASCAL FAR inet_addr (const char FAR * cp);
        s32_inet_addr(*CSTRING),ULONG,RAW,PASCAL,NAME('INET_ADDR'),DLL(dll_mode)

        !char FAR * PASCAL FAR inet_ntoa (struct in_addr in);
        s32_inet_ntoa(LONG),LONG,PASCAL,NAME('INET_NTOA'),DLL(dll_mode)

        !int PASCAL FAR listen (SOCKET s, int backlog);
        s32_listen(SOCKET,SHORT),SHORT,PASCAL,NAME('LISTEN'),DLL(dll_mode)

        !u_long PASCAL FAR ntohl (u_long netlong);
        s32_ntohl(ULONG),ULONG,PASCAL,NAME('NTOHL'),DLL(dll_mode)

        !u_short PASCAL FAR ntohs (u_short netshort);
        s32_ntohs(USHORT),USHORT,PASCAL,NAME('NTOHS'),DLL(dll_mode)

        !int PASCAL FAR recv (SOCKET s, char FAR * buf, int len, int flags);
        s32_recv(SOCKET,ULONG,SHORT,SHORT),SHORT,RAW,PASCAL,NAME('RECV'),DLL(dll_mode)

        !int PASCAL FAR recvfrom (SOCKET s, char FAR * buf, int len, int flags,
        !                struct sockaddr FAR *from, int FAR * fromlen);
        !s32_recvfrom(SOCKET,*CSTRING,SHORT,SHORT,*SOCKADDR,*SHORT),SHORT,RAW,PASCAL,NAME('RECVFROM'),DLL(dll_mode)
        s32_recvfrom(SOCKET,ULONG,SHORT,SHORT,ULONG,ULONG),SHORT,RAW,PASCAL,NAME('RECVFROM'),DLL(dll_mode)



        !int PASCAL FAR select (int nfds, fd_set FAR *readfds, fd_set FAR *writefds,
        !              fd_set FAR *exceptfds, const struct timeval FAR *timeout);
        s32_select(SHORT,<*FD_SET>,<*FD_SET>,<*FD_SET>,*TIMEVAL),SHORT,RAW,PASCAL,NAME('SELECT'),DLL(dll_mode)

        !int PASCAL FAR send (SOCKET s, const char FAR * buf, int len, int flags);
        s32_send(SOCKET,ULONG,SHORT,SHORT),SHORT,RAW,PASCAL,NAME('SEND')

        !int PASCAL FAR sendto (SOCKET s, const char FAR * buf, int len, int flags,
        !              const struct sockaddr FAR *to, int tolen);
        s32_sendto(SOCKET,*CSTRING,SHORT,SHORT,*SOCKADDR,SHORT),SHORT,RAW,PASCAL,NAME('SENDTO'),DLL(dll_mode)

        !int PASCAL FAR setsockopt (SOCKET s, int level, int optname,
        !                  const char FAR * optval, int optlen);
        s32_setsockopt(SOCKET,LONG,LONG,LONG,LONG),SHORT,RAW,PASCAL,NAME('SETSOCKOPT'),DLL(dll_mode)

        !int PASCAL FAR shutdown (SOCKET s, int how);
        s32_shutdown(SOCKET,SHORT),SHORT,RAW,PASCAL,NAME('SHUTDOWN'),DLL(dll_mode)

        !SOCKET PASCAL FAR socket (int af, int type, int protocol);
        s32_socket(SHORT,SHORT,SHORT),USHORT,RAW,PASCAL,NAME('SOCKET'),DLL(dll_mode)

    !----------------------------
    !---- DATABASE FUNCTIONS ----
    !----------------------------
        s32_gethostbyaddr(*LONG,LONG,LONG),LONG,PASCAL,RAW,NAME('GETHOSTBYADDR'),DLL(dll_mode)

        !struct hostent FAR * PASCAL FAR gethostbyaddr(const char FAR * addr,
        !                                     int len, int type);

        !struct hostent FAR * PASCAL FAR gethostbyname(const char FAR * name);
        s32_gethostbyname(*CSTRING),LONG,PASCAL,RAW,NAME('GETHOSTBYNAME'),DLL(dll_mode)

        !int PASCAL FAR gethostname (char FAR * name, int namelen);
        s32_gethostname(*CSTRING,SHORT),SHORT,RAW,PASCAL,NAME('GETHOSTNAME'),DLL(dll_mode),PROC

        !struct servent FAR * PASCAL FAR getservbyport(int port, const char FAR * proto);
        !we make parm#2 optional so we can easily pass a NULL - just omit it
        s32_getservbyport(SHORT,<*CSTRING>),LONG,RAW,PASCAL,NAME('GETSERVBYPORT'),DLL(dll_mode)

        !struct servent FAR * PASCAL FAR getservbyname(const char FAR * name,
        !                                     const char FAR * proto);
        !we make parm#2 optional so we can easily pass a NULL - just omit it
        s32_getservbyname(*CSTRING,<*CSTRING>),LONG,RAW,PASCAL,NAME('GETSERVBYNAME'),DLL(dll_mode)

        !struct protoent FAR * PASCAL FAR getprotobynumber(int proto);
        s32_getprotobynumber(SHORT),LONG,RAW,PASCAL,NAME('GETPROTOBYNUMBER'),DLL(dll_mode)

        !struct protoent FAR * PASCAL FAR getprotobyname(const char FAR * name);

    !-------------------------------
    !---- MS WINDOWS EXTENSIONS ----
    !-------------------------------

        !int PASCAL FAR WSAStartup(WORD wVersionRequired, LPWSADATA lpWSAData);
        WSAStartup(UNSIGNED,*WSADATA),SHORT,RAW,PASCAL,NAME('WSASTARTUP'),DLL(dll_mode)

        !int PASCAL FAR WSACleanup(void);
        WSACleanup(),PASCAL,NAME('WSACLEANUP'),DLL(dll_mode)

        !void PASCAL FAR WSASetLastError(int iError);

        !int PASCAL FAR WSAGetLastError(void);
        WSAGetLastError(),SHORT,RAW,PASCAL,NAME('WSAGETLASTERROR'),DLL(dll_mode)

        !BOOL PASCAL FAR WSAIsBlocking(void);

        !int PASCAL FAR WSAUnhookBlockingHook(void);

        !FARPROC PASCAL FAR WSASetBlockingHook(FARPROC lpBlockFunc);

        !int PASCAL FAR WSACancelBlockingCall(void);
        WSACancelBlockingCall(),SHORT,RAW,PASCAL,NAME('WSACANCELBLOCKINGCALL'),DLL(dll_mode)

        !HANDLE PASCAL FAR WSAAsyncGetServByName(HWND hWnd, u_int wMsg,
        !                               const char FAR * name,
        !                               const char FAR * proto,
        !                               char FAR * buf, int buflen);

        !HANDLE PASCAL FAR WSAAsyncGetServByPort(HWND hWnd, u_int wMsg, int port,
        !                               const char FAR * proto, char FAR * buf,
        !                               int buflen);

        !HANDLE PASCAL FAR WSAAsyncGetProtoByName(HWND hWnd, u_int wMsg,
        !                                const char FAR * name, char FAR * buf,
        !                                int buflen);

        !HANDLE PASCAL FAR WSAAsyncGetProtoByNumber(HWND hWnd, u_int wMsg,
        !                                  int number, char FAR * buf,
        !                                  int buflen);

        !HANDLE PASCAL FAR WSAAsyncGetHostByName(HWND hWnd, u_int wMsg,
        !                               const char FAR * name, char FAR * buf,
        !                               int buflen);
        WSAAsyncgethostbyname(USHORT,USHORT,LONG,LONG,SHORT),SHORT,RAW,PASCAL,NAME('WSAASYNCGETHOSTBYNAME'),DLL(dll_mode)

        !HANDLE PASCAL FAR WSAAsyncGetHostByAddr(HWND hWnd, u_int wMsg,
        !                               const char FAR * addr, int len, int type,
        !                               const char FAR * buf, int buflen);
       !!!WSAAsyncgethostbyaddr(USHORT,USHORT,LONG,LONG,SHORT),SHORT,RAW,PASCAL,NAME('WSAASYNCGETHOSTBYADDR'),DLL(dll_mode)
  WSAAsyncgethostbyaddr(USHORT,USHORT,*long,USHORT,USHORT,LONG,USHORT),SHORT,RAW,PASCAL,NAME('WSAASYNCGETHOSTBYADDR'),DLL(dll_mode)

        !int PASCAL FAR WSACancelAsyncRequest(HANDLE hAsyncTaskHandle);
        WSACancelAsyncRequest( USHORT ),SHORT,RAW,PASCAL,NAME('WSACANCELASYNCREQUEST'),DLL(dll_mode)

        !int PASCAL FAR WSAAsyncSelect(SOCKET s, HWND hWnd, u_int wMsg,
        !                      long lEvent);
       ! WSAAsyncSelect(USHORT,USHORT,USHORT,LONG),SHORT,PASCAL,NAME('WSAASYNCSELECT'),DLL(dll_mode)
        WSAAsyncSelect(SOCKET,HWnd,USHORT,LONG),SHORT,PASCAL,NAME('WSAASYNCSELECT'),DLL(dll_mode)
  END